# PHP Backend — Route Permit System (Laragon)

Backend PHP Native untuk Sistem Pengajuan Izin Trayek.  
Didesain untuk berjalan di **Laragon** (`www/backend-php/`).

---

## Setup di Laragon

### 1. Letakkan folder di www/

Salin folder `backend-php` ke:
```
C:\laragon\www\backend-php\
```

Struktur akhir:
```
C:\laragon\www\
└── backend-php\
    ├── index.php
    ├── .htaccess
    ├── .env
    ├── config\
    ├── controllers\
    ├── middleware\
    ├── models\
    ├── routes\
    ├── services\
    └── uploads\
```

### 2. Import Database

Buka **HeidiSQL** (sudah include di Laragon) atau phpMyAdmin, lalu jalankan:
```sql
-- Buat database dulu jika belum ada
CREATE DATABASE route_permit_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```
Kemudian import file `database.sql`.

### 3. Buat file .env

```bash
# Di folder backend-php, copy file .env.example
cp .env.example .env
```

Isi `.env` (Laragon default MySQL tidak pakai password):
```env
DB_HOST=localhost
DB_PORT=3306
DB_USER=root
DB_PASSWORD=
DB_NAME=route_permit_db

JWT_SECRET=ganti_dengan_string_panjang_acak_rahasia
JWT_EXPIRES_IN=28800

FRONTEND_URL=http://localhost:5173
```

### 4. Pastikan mod_rewrite aktif

Laragon biasanya sudah aktif. Kalau belum:
- Buka Laragon → klik kanan tray icon → Apache → `httpd.conf`
- Pastikan baris `LoadModule rewrite_module modules/mod_rewrite.so` tidak di-comment
- Pastikan `AllowOverride All` pada `<Directory "C:/laragon/www">`

### 5. Test Backend

Buka browser atau Postman:
```
GET http://localhost/backend-php/api/health
```

Respons yang benar:
```json
{"status":"ok","timestamp":"2024-02-15T10:00:00+07:00"}
```

### 6. Konfigurasi Frontend

Update file `.env` di folder `frontend/`:
```env
VITE_API_URL=http://localhost/backend-php/api
```

Lalu jalankan Vite dev server seperti biasa:
```bash
cd frontend
npm run dev
```

---

## URL API (Base: `http://localhost/backend-php`)

| Method | Endpoint | Auth | Keterangan |
|--------|----------|------|------------|
| GET | `/api/health` | No | Health check |
| POST | `/api/auth/login` | No | Admin login |
| GET | `/api/auth/me` | JWT | Info admin aktif |
| GET | `/api/routes` | No | Daftar trayek |
| GET | `/api/routes/:id` | No | Detail trayek |
| POST | `/api/routes` | JWT | Tambah trayek |
| PUT | `/api/routes/:id` | JWT | Edit trayek |
| DELETE | `/api/routes/:id` | JWT | Hapus trayek |
| POST | `/api/submissions` | No | Kirim pengajuan |
| GET | `/api/submissions/track/:reg` | No | Tracking publik |
| GET | `/api/submissions/dashboard` | JWT | Statistik dashboard |
| GET | `/api/submissions` | JWT | Daftar pengajuan |
| GET | `/api/submissions/:id` | JWT | Detail pengajuan |
| PATCH | `/api/submissions/:id/status` | JWT | Update status |
| GET | `/api/submissions/:id/files/:field/preview` | JWT | Preview PDF inline |
| GET | `/api/submissions/:id/files/:field/download` | JWT | Download PDF |
| GET | `/api/submissions/:id/download-zip` | JWT | Download semua (ZIP) |
| GET | `/api/admin/profile` | JWT | Profil admin |

---

## Default Admin

- **Email:** `admin@routepermit.id`
- **Password:** `admin123`

---

## Struktur File

```
backend-php/
├── index.php                    # Entry point
├── .htaccess                    # URL rewrite (RewriteBase /backend-php/)
├── .env                         # Konfigurasi (buat dari .env.example)
├── php.ini                      # Upload limit hints
├── config/
│   ├── env.php                  # Parser .env + fungsi env()
│   └── database.php             # PDO singleton class DB
├── routes/
│   ├── router.php               # Custom router (strip subdirectory otomatis)
│   └── api.php                  # Definisi semua endpoint
├── controllers/
│   ├── BaseController.php       # Helper: json(), validate(), requireAuth()
│   ├── AuthController.php
│   ├── RouteController.php
│   ├── SubmissionController.php
│   └── AdminController.php
├── middleware/
│   └── AuthMiddleware.php       # Verifikasi JWT Bearer token
├── models/
│   ├── AdminModel.php
│   ├── RouteModel.php
│   └── SubmissionModel.php
├── services/
│   ├── JwtService.php           # JWT manual HMAC-SHA256
│   ├── RegistrationService.php  # Generator TRX-YYYYMMDD-XXXX
│   └── ZipService.php           # ZipArchive stream ke browser
└── uploads/
    ├── .htaccess                # Deny direct access
    └── pengajuan/
        └── {REG_NUMBER}/        # File per pengajuan
```

---

## Troubleshooting

**404 semua endpoint:**
- Pastikan `mod_rewrite` aktif di Apache Laragon
- Cek `AllowOverride All` di konfigurasi Apache
- Pastikan `RewriteBase /backend-php/` sesuai nama folder di www/

**Error koneksi database:**
- Laragon default: `user=root`, `password=` (kosong)
- Cek nama database sudah sesuai di `.env`

**CORS error di browser:**
- Pastikan `FRONTEND_URL` di `.env` sesuai dengan URL frontend (biasanya `http://localhost:5173`)

**Upload file gagal:**
- Cek permission folder `uploads/pengajuan/` (harus writable)
- Di Windows/Laragon biasanya sudah OK secara default
