<?php
declare(strict_types=1);

require_once __DIR__ . '/BaseController.php';
require_once __DIR__ . '/../models/AdminModel.php';

class AdminController extends BaseController
{
    public function profile(array $params): void
    {
        $payload = $this->requireAuth();
        $admin   = AdminModel::findById((int) $payload['id']);

        if (!$admin) {
            $this->notFound('Admin not found.');
            return;
        }

        $this->json(['admin' => $payload]);
    }
}
