<?php
declare(strict_types=1);

require_once __DIR__ . '/BaseController.php';
require_once __DIR__ . '/../models/AdminModel.php';
require_once __DIR__ . '/../services/JwtService.php';

class AuthController extends BaseController
{
    public function login(array $params): void
    {
        $body   = $this->body();
        $errors = $this->validate($body, [
            'email'    => 'required|email',
            'password' => 'required',
        ]);

        if ($errors) {
            $this->validationError($errors);
            return;
        }

        $admin = AdminModel::findByEmail(trim($body['email']));
        if (!$admin || !AdminModel::verifyPassword($body['password'], $admin['password'])) {
            $this->json(['message' => 'Invalid email or password.'], 401);
            return;
        }

        $token = JwtService::generate([
            'id'    => $admin['id'],
            'email' => $admin['email'],
            'name'  => $admin['name'],
        ]);

        $this->json([
            'token' => $token,
            'admin' => [
                'id'    => $admin['id'],
                'name'  => $admin['name'],
                'email' => $admin['email'],
            ],
        ]);
    }

    public function me(array $params): void
    {
        $payload = $this->requireAuth();
        $admin   = AdminModel::findById((int) $payload['id']);

        if (!$admin) {
            $this->notFound('Admin not found.');
            return;
        }

        $this->json($admin);
    }
}
