<?php
declare(strict_types=1);

require_once __DIR__ . '/../services/JwtService.php';

class AuthMiddleware
{
    /**
     * Verify JWT and return decoded payload.
     * Sends 401 and exits if invalid.
     */
    public static function handle(): array
    {
        $authHeader = $_SERVER['HTTP_AUTHORIZATION'] ?? '';

        if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
            http_response_code(401);
            echo json_encode(['message' => 'Unauthorized: No token provided.']);
            exit;
        }

        $token   = substr($authHeader, 7);
        $payload = JwtService::verify($token);

        if (!$payload) {
            http_response_code(401);
            echo json_encode(['message' => 'Unauthorized: Invalid or expired token.']);
            exit;
        }

        return $payload;
    }
}
