<?php
declare(strict_types=1);

class AdminModel
{
    public static function findByEmail(string $email): ?array
    {
        $stmt = DB::query('SELECT * FROM admins WHERE email = ?', [$email]);
        $row  = $stmt->fetch();
        return $row ?: null;
    }

    public static function findById(int $id): ?array
    {
        $stmt = DB::query(
            'SELECT id, name, email, created_at FROM admins WHERE id = ?',
            [$id]
        );
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function verifyPassword(string $plaintext, string $hash): bool
    {
        return password_verify($plaintext, $hash);
    }
}
