<?php
declare(strict_types=1);

class RouteModel
{
    public static function getAll(): array
    {
        return DB::query(
            'SELECT * FROM routes ORDER BY nama_trayek ASC'
        )->fetchAll();
    }

    public static function getById(int $id): ?array
    {
        $stmt = DB::query('SELECT * FROM routes WHERE id = ?', [$id]);
        $row  = $stmt->fetch();
        return $row ?: null;
    }

    public static function create(string $namaTayek): int
    {
        DB::query(
            'INSERT INTO routes (nama_trayek) VALUES (?)',
            [$namaTayek]
        );
        return (int) DB::lastInsertId();
    }

    public static function update(int $id, string $namaTayek): int
    {
        $stmt = DB::query(
            'UPDATE routes SET nama_trayek = ? WHERE id = ?',
            [$namaTayek, $id]
        );
        return $stmt->rowCount();
    }

    public static function delete(int $id): int
    {
        // Check foreign key constraint manually for a clear error
        $stmt = DB::query(
            'SELECT COUNT(*) AS cnt FROM submissions WHERE route_id = ?',
            [$id]
        );
        if ((int) $stmt->fetch()['cnt'] > 0) {
            throw new RuntimeException('Cannot delete route: it has associated submissions.');
        }

        $stmt = DB::query('DELETE FROM routes WHERE id = ?', [$id]);
        return $stmt->rowCount();
    }
}
