<?php
declare(strict_types=1);

class SubmissionModel
{
    public static function create(array $data): int
    {
        DB::query(
            "INSERT INTO submissions
                (registration_number, route_id, owner_name, phone, plate_number, address,
                 supervision_card, stnk, inspection_book, business_license, insurance, ktp, retribution_proof)
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
            [
                $data['registration_number'],
                $data['route_id'],
                $data['owner_name'],
                $data['phone'],
                $data['plate_number'],
                $data['address'],
                $data['supervision_card'],
                $data['stnk'],
                $data['inspection_book'],
                $data['business_license'],
                $data['insurance'],
                $data['ktp'],
                $data['retribution_proof'],
            ]
        );
        return (int) DB::lastInsertId();
    }

    public static function getAll(array $filters = []): array
    {
        $sql    = "SELECT s.*, r.nama_trayek FROM submissions s LEFT JOIN routes r ON s.route_id = r.id WHERE 1=1";
        $params = [];

        if (!empty($filters['status'])) {
            $sql     .= ' AND s.status = ?';
            $params[] = $filters['status'];
        }
        if (!empty($filters['route_id'])) {
            $sql     .= ' AND s.route_id = ?';
            $params[] = $filters['route_id'];
        }

        $sql .= ' ORDER BY s.created_at DESC';
        return DB::query($sql, $params)->fetchAll();
    }

    public static function getById(int $id): ?array
    {
        $stmt = DB::query(
            "SELECT s.*, r.nama_trayek FROM submissions s LEFT JOIN routes r ON s.route_id = r.id WHERE s.id = ?",
            [$id]
        );
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function getByRegistrationNumber(string $regNumber): ?array
    {
        $stmt = DB::query(
            "SELECT s.*, r.nama_trayek FROM submissions s LEFT JOIN routes r ON s.route_id = r.id WHERE s.registration_number = ?",
            [$regNumber]
        );
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function updateStatus(int $id, string $status, ?string $adminNotes): int
    {
        $stmt = DB::query(
            'UPDATE submissions SET status = ?, admin_notes = ? WHERE id = ?',
            [$status, $adminNotes, $id]
        );
        return $stmt->rowCount();
    }

    public static function getDashboardStats(): array
    {
        return DB::query(
            "SELECT
                COUNT(*) AS total,
                SUM(status = 'pending')  AS pending,
                SUM(status = 'approved') AS approved,
                SUM(status = 'rejected') AS rejected
             FROM submissions"
        )->fetch();
    }

    public static function getDailyChart(int $days = 30): array
    {
        return DB::query(
            "SELECT DATE(created_at) AS date, COUNT(*) AS count
             FROM submissions
             WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL ? DAY)
             GROUP BY DATE(created_at)
             ORDER BY date ASC",
            [$days]
        )->fetchAll();
    }
}
