<?php
declare(strict_types=1);

// ── Health check ──────────────────────────────────────────────────────────────
$router->get('/api/health', function (array $p) {
    echo json_encode(['status' => 'ok', 'timestamp' => date('c')]);
});

// ── Auth ──────────────────────────────────────────────────────────────────────
$router->post('/api/auth/login',    ['AuthController', 'login']);
$router->get('/api/auth/me',        ['AuthController', 'me']);

// ── Routes (trayek) ───────────────────────────────────────────────────────────
$router->get('/api/routes',           ['RouteController', 'index']);
$router->get('/api/routes/:id',       ['RouteController', 'show']);
$router->post('/api/routes',          ['RouteController', 'store']);
$router->put('/api/routes/:id',       ['RouteController', 'update']);
$router->delete('/api/routes/:id',    ['RouteController', 'destroy']);

// ── Submissions ───────────────────────────────────────────────────────────────
$router->post('/api/submissions',                                   ['SubmissionController', 'store']);
$router->get('/api/submissions/track/:reg_number',                  ['SubmissionController', 'trackByRegNumber']);
$router->get('/api/submissions/dashboard',                          ['SubmissionController', 'dashboardStats']);
$router->get('/api/submissions',                                    ['SubmissionController', 'index']);
$router->get('/api/submissions/:id',                                ['SubmissionController', 'show']);
$router->patch('/api/submissions/:id/status',                       ['SubmissionController', 'updateStatus']);
$router->get('/api/submissions/:id/files/:field/preview',           ['SubmissionController', 'previewFile']);
$router->get('/api/submissions/:id/files/:field/download',          ['SubmissionController', 'downloadFile']);
$router->get('/api/submissions/:id/download-zip',                   ['SubmissionController', 'downloadZip']);

// ── Admin ─────────────────────────────────────────────────────────────────────
$router->get('/api/admin/profile',   ['AdminController', 'profile']);
