<?php
declare(strict_types=1);

class RegistrationService
{
    /**
     * Generate registration number: TRX-YYYYMMDD-XXXX
     * XXXX = zero-padded daily sequence
     */
    public static function generate(): string
    {
        $dateStr = date('Ymd');
        $prefix  = "TRX-{$dateStr}-";

        $stmt = DB::query(
            "SELECT COUNT(*) AS cnt FROM submissions WHERE registration_number LIKE ?",
            ["{$prefix}%"]
        );

        $count = (int) $stmt->fetch()['cnt'];
        $seq   = str_pad((string) ($count + 1), 4, '0', STR_PAD_LEFT);

        return "{$prefix}{$seq}";
    }
}
