<?php
declare(strict_types=1);

class ZipService
{
    private const FILE_LABELS = [
        'supervision_card'  => 'Kartu_Pengawasan_Asli',
        'stnk'              => 'Fotokopi_STNK',
        'inspection_book'   => 'Fotokopi_Buku_KIR',
        'business_license'  => 'Fotokopi_Izin_Usaha',
        'insurance'         => 'Fotokopi_Asuransi_JasaRaharja',
        'ktp'               => 'KTP_Pemilik',
        'retribution_proof' => 'Bukti_Pembayaran_Retribusi',
    ];

    /**
     * Stream a ZIP of all submission documents to the browser.
     */
    public static function streamSubmission(array $submission): void
    {
        $regNumber  = $submission['registration_number'];
        $folderPath = __DIR__ . "/../uploads/pengajuan/{$regNumber}";
        $tmpZip     = sys_get_temp_dir() . "/{$regNumber}_" . time() . ".zip";

        $zip = new ZipArchive();
        if ($zip->open($tmpZip, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
            http_response_code(500);
            echo json_encode(['message' => 'Could not create ZIP archive.']);
            return;
        }

        foreach (self::FILE_LABELS as $field => $label) {
            $filename = $submission[$field] ?? null;
            if (!$filename) {
                continue;
            }
            $filePath = "{$folderPath}/{$filename}";
            if (file_exists($filePath)) {
                $zip->addFile($filePath, "{$label}.pdf");
            }
        }

        $zip->close();

        // Stream to browser
        header('Content-Type: application/zip');
        header("Content-Disposition: attachment; filename=\"{$regNumber}_documents.zip\"");
        header('Content-Length: ' . filesize($tmpZip));
        header('Cache-Control: no-cache');

        readfile($tmpZip);
        unlink($tmpZip);
    }
}
